<?php
/**
 * Class that operate on table 'transferclientaccounts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-09-04 12:44
 */
class TransferclientaccountsMySqlDAO implements TransferclientaccountsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TransferclientaccountsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM transferclientaccounts WHERE transferid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM transferclientaccounts';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM transferclientaccounts ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param transferclientaccount primary key
 	 */
	public function delete($transferid){
		$sql = 'DELETE FROM transferclientaccounts WHERE transferid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($transferid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TransferclientaccountsMySql transferclientaccount
 	 */
	public function insert($transferclientaccount){
		$sql = 'INSERT INTO transferclientaccounts (clientidfrom, clientidto, transfervalue, transferdate, userid, conditions, dailyentryid, comment) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($transferclientaccount->clientidfrom);
		$sqlQuery->setNumber($transferclientaccount->clientidto);
		$sqlQuery->set($transferclientaccount->transfervalue);
		$sqlQuery->set($transferclientaccount->transferdate);
		$sqlQuery->setNumber($transferclientaccount->userid);
		$sqlQuery->setNumber($transferclientaccount->conditions);
		$sqlQuery->setNumber($transferclientaccount->dailyentryid);
		$sqlQuery->set($transferclientaccount->comment);

		$id = $this->executeInsert($sqlQuery);	
		$transferclientaccount->transferid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TransferclientaccountsMySql transferclientaccount
 	 */
	public function update($transferclientaccount){
		$sql = 'UPDATE transferclientaccounts SET clientidfrom = ?, clientidto = ?, transfervalue = ?, transferdate = ?, userid = ?, conditions = ?, dailyentryid = ?, comment = ? WHERE transferid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($transferclientaccount->clientidfrom);
		$sqlQuery->setNumber($transferclientaccount->clientidto);
		$sqlQuery->set($transferclientaccount->transfervalue);
		$sqlQuery->set($transferclientaccount->transferdate);
		$sqlQuery->setNumber($transferclientaccount->userid);
		$sqlQuery->setNumber($transferclientaccount->conditions);
		$sqlQuery->setNumber($transferclientaccount->dailyentryid);
		$sqlQuery->set($transferclientaccount->comment);

		$sqlQuery->setNumber($transferclientaccount->transferid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM transferclientaccounts';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientidfrom($value){
		$sql = 'SELECT * FROM transferclientaccounts WHERE clientidfrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientidto($value){
		$sql = 'SELECT * FROM transferclientaccounts WHERE clientidto = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTransfervalue($value){
		$sql = 'SELECT * FROM transferclientaccounts WHERE transfervalue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTransferdate($value){
		$sql = 'SELECT * FROM transferclientaccounts WHERE transferdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM transferclientaccounts WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM transferclientaccounts WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDailyentryid($value){
		$sql = 'SELECT * FROM transferclientaccounts WHERE dailyentryid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComment($value){
		$sql = 'SELECT * FROM transferclientaccounts WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientidfrom($value){
		$sql = 'DELETE FROM transferclientaccounts WHERE clientidfrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientidto($value){
		$sql = 'DELETE FROM transferclientaccounts WHERE clientidto = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTransfervalue($value){
		$sql = 'DELETE FROM transferclientaccounts WHERE transfervalue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTransferdate($value){
		$sql = 'DELETE FROM transferclientaccounts WHERE transferdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM transferclientaccounts WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM transferclientaccounts WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDailyentryid($value){
		$sql = 'DELETE FROM transferclientaccounts WHERE dailyentryid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComment($value){
		$sql = 'DELETE FROM transferclientaccounts WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TransferclientaccountsMySql 
	 */
	protected function readRow($row){
		$transferclientaccount = new Transferclientaccount();
		
		$transferclientaccount->transferid = $row['transferid'];
		$transferclientaccount->clientidfrom = $row['clientidfrom'];
		$transferclientaccount->clientidto = $row['clientidto'];
		$transferclientaccount->transfervalue = $row['transfervalue'];
		$transferclientaccount->transferdate = $row['transferdate'];
		$transferclientaccount->userid = $row['userid'];
		$transferclientaccount->conditions = $row['conditions'];
		$transferclientaccount->dailyentryid = $row['dailyentryid'];
		$transferclientaccount->comment = $row['comment'];

		$transferclientaccount->clientfromname = isset($row['clientfromname']) ? $row['clientfromname'] : '';
        $transferclientaccount->clienttoname = isset($row['clienttoname']) ? $row['clienttoname'] : '';

		return $transferclientaccount;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TransferclientaccountsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>